import json
from argparse import ArgumentParser

from sepelib.core import config
from juggler_sdk import JugglerApi

from walle.util.cloud_tools import get_config_path
from walle.main import load_config
from infra.walle.server.scripts.walle_backend_monitoring_updater import common
from infra.walle.server.scripts.walle_backend_monitoring_updater import cron_juggler_updater


def update_checks():
    args = _parse_args()
    args.config_context = args.config_context or [("log_dir", "logs")]
    load_config(args)
    mark = f"walle_autogenerated.{common.get_env()}"

    api_kwargs = config.get_value("juggler.client_kwargs")
    api_kwargs["dry_run"] = args.dry_run
    api_kwargs["mark"] = mark
    with JugglerApi(**api_kwargs) as api:
        update_results = cron_juggler_updater.update_cron_juggler_aggregates(api)

    for update_result in update_results:
        if update_result.result.changed or args.dry_run:
            diff = update_result.result.diff.to_dict()
            if "changes" not in diff or diff["changes"]:
                print(
                    f"Check https://juggler.yandex-team.ru/check_details/?"
                    f"host={update_result.host}&service={update_result.service}:\n"
                    f"{json.dumps(diff, indent=2, sort_keys=True)}"
                )


def _parse_args():
    parser = ArgumentParser(description="Cron juggler updater")
    parser.add_argument("-c", "--config", default=get_config_path(), help="configuration file path", required=True)
    parser.add_argument("--dry-run", default=False, action="store_true", help="dry-run option")
    parser.add_argument("-d", "--debug", default=False, action="store_true", help="debug mode")
    config.augment_args_parser(parser)
    return parser.parse_args()
