import walle.projects
from walle.admin_requests.constants import RequestTypes
from walle.clients.juggler import JugglerDowntimeName
from walle.constants import NetworkTarget
from walle.projects import DEFAULT_CMS_NAME
from walle.stages import Stages, StageTerminals


def monitor(sb, checks_to_monitor=(), monitoring_timeout=None, checks_for_use=None):
    sb.stage(
        name=Stages.MONITOR,
        checks=sorted(set(checks_to_monitor)),
        monitoring_timeout=monitoring_timeout,
        checks_for_use=checks_for_use,
    )


def cloud_post_processor(sb, need_profile, need_redeploy):
    sb.stage(name=Stages.CLOUD_POST_PROCESSOR, profile_after_task=need_profile, redeploy_after_task=need_redeploy)


def cancel_admin_requests(sb):
    sb.stage(name=Stages.CANCEL_ADMIN_REQUESTS)


def reset_health_status(sb, health_status_accuracy=None):
    sb.stage(name=Stages.RESET_HEALTH_STATUS, health_status_accuracy=health_status_accuracy)


def acquire_permission(
    sb,
    action=None,
    task_group=None,
    reason=None,
    failure=None,
    check_names=None,
    force_new_cms_task=None,
    extra=None,
    ignore_cms=None,
    workdays=None,
    failure_type=None,
):
    sb.stage(
        name=Stages.ACQUIRE_PERMISSION,
        action=action,
        task_group=task_group,
        comment=reason,
        failure=failure,
        check_names=check_names,
        failure_type=failure_type,
        force_new_cms_task=force_new_cms_task,
        extra=extra,
        ignore_cms=ignore_cms,
        workdays=workdays,
    )


def set_downtime(sb, juggler_downtime_name=JugglerDowntimeName.DEFAULT):
    sb.stage(name=Stages.SET_DOWNTIME, juggler_downtime_name=juggler_downtime_name)


def switch_vlans(sb, network=None, vlans=None, native_vlan=None, extra_vlans=None):
    terminators = None
    if network == NetworkTarget.PARKING:
        terminators = {StageTerminals.SWITCH_MISSING: StageTerminals.SKIP}
    sb.stage(
        name=Stages.SWITCH_VLANS,
        network=network,
        vlans=vlans,
        native_vlan=native_vlan,
        extra_vlans=extra_vlans,
        terminators=terminators,
    )


def log_completed_operation(sb, operation_type, params):
    sb.stage(name=Stages.LOG_COMPLETED_OPERATION, operation=operation_type, params=params)


def ssh_reboot(sb, terminators=None, check_post_code=True):
    sb.stage(name=Stages.SSH_REBOOT, terminators=terminators, check_post_code=check_post_code)


def itdc_reboot(sb, reason=None):
    sb.stage(name=Stages.HW_REPAIR, decision_params=dict(request_type=RequestTypes.REBOOT.type), decision_reason=reason)


def kexec_reboot(sb, terminators=None):
    sb.stage(name=Stages.KEXEC_REBOOT, terminators=terminators)


def power_off(sb, soft=False, skip_errors=False):
    terminators = {StageTerminals.FAIL: StageTerminals.SKIP} if skip_errors else None
    sb.stage(name=Stages.POWER_OFF, soft=soft, terminators=terminators)


def power_on(sb, check_post_code=None, upgrade_to_profile=None, pxe=None):
    sb.stage(name=Stages.POWER_ON, check_post_code=check_post_code, upgrade_to_profile=upgrade_to_profile, pxe=pxe)


def lui_remove(sb):
    sb.stage(name=Stages.LUI_REMOVE)


def delete_task_from_cms(sb, cms_task_id):
    if cms_task_id:
        sb.stage(Stages.DROP_CMS_TASK, cms_task_id=cms_task_id)


def complete_deletion(sb):
    sb.stage(name=Stages.COMPLETE_DELETION)


def wait_for_active_mac(sb):
    sb.stage(name=Stages.WAIT_FOR_ACTIVE_MAC)


def setup_dns(sb, clear=None, create=None):
    sb.stage(name=Stages.SETUP_DNS, clear=clear, create=create)


def release_host(sb):
    sb.stage(name=Stages.COMPLETE_RELEASING)


def switch_default_cms_task_project(sb, cms_task_id, source_project_id, target_project_id):
    target_project = walle.projects.get_by_id(target_project_id)
    source_project = walle.projects.get_by_id(source_project_id)

    if source_project.cms != DEFAULT_CMS_NAME:
        return

    if all((cms_task_id, source_project.id, target_project.id)):
        sb.stage(
            name=Stages.SWITCH_DEFAULT_CMS_PROJECT,
            cms_task_id=cms_task_id,
            source_project_id=source_project.id,
            target_project_id=target_project.id,
        )


def switch_project(sb, target_project_id, restrictions):
    sb.stage(name=Stages.SWITCH_PROJECT, project=target_project_id, host_restrictions=restrictions)


def add_fqdn_to_cauth(sb, terminators=None):
    sb.stage(name=Stages.ADD_HOST_TO_CAUTH, terminators=terminators)


def assign_bot_project(sb, bot_project_id):
    if bot_project_id:
        sb.stage(name=Stages.ASSIGN_BOT_PROJECT, bot_project_id=bot_project_id)


def set_maintenance(sb, ticket_key, timeout_time, timeout_status, operation_state, reason=None):
    sb.stage(
        name=Stages.SET_MAINTENANCE,
        ticket_key=ticket_key,
        timeout_time=timeout_time,
        timeout_status=timeout_status,
        operation_state=operation_state,
        reason=reason,
    )


def set_assigned(sb, reason=None):
    sb.stage(name=Stages.SET_ASSIGNED, reason=reason)


def set_hostname(sb, free=None):
    """
    :param free: assign free hostname like free-0000.xxx.yandex.net
    :type free: bool
    """
    juggler_downtime_name = JugglerDowntimeName.DELETED_HOST if free else JugglerDowntimeName.DEFAULT
    with sb.nested(Stages.SET_HOSTNAME) as rename_builder:
        rename_builder.stage(Stages.ALLOCATE_HOSTNAME, free=free)
        rename_builder.stage(
            Stages.SET_DOWNTIME, juggler_downtime_name=juggler_downtime_name
        )  # set downtime for the new host's name
        rename_builder.stage(Stages.ASSIGN_HOSTNAME)


def set_probation(sb, reason):
    sb.stage(Stages.SET_PROBATION, reason=reason)


def complete_preparing(
    sb,
    host_provisioner,
    host_config,
    host_deploy_config_policy,
    host_deploy_tags,
    host_deploy_network,
    extra_vlans,
    restrictions,
):
    sb.stage(
        Stages.COMPLETE_PREPARING,
        provisioner=host_provisioner,
        config=host_config,
        deploy_config_policy=host_deploy_config_policy,
        deploy_tags=host_deploy_tags,
        deploy_network=host_deploy_network,
        extra_vlans=extra_vlans,
        restrictions=restrictions,
    )


def ensure_host_distribution(sb):
    sb.stage(name=Stages.WAIT_FOR_BOT_PREORDER)


def foo_and_bar_stages(sb, cycles, foo_args, bar_args):
    for i in range(cycles):
        sb.stage(Stages.FOO, **foo_args)
        sb.stage(Stages.BAR, **bar_args)


def fqdn_deinvalidation(sb):
    sb.stage(name=Stages.FQDN_DEINVALIDATION)
