from walle.errors import BadRequestError
from walle.network import get_free_host_name_template


def validate_hostname(host):
    name_template = get_free_host_name_template()
    if not host.name:
        raise BadRequestError("Can't leave current host's name: Name cannot be empty.")
    elif name_template.fqdn_matches(host.name):
        raise BadRequestError("Can't leave current host's name: Name matches the existing NameTemplate.")
