"""Provides utilities for managing admin requests.

Possible request statuses:
* NEW - on request creation (processed requests may have these state due to errors)
* UNKNOWN - request with such ID doesn't exist
* DELETED - request hasn't been added and needs retry or it has been cancelled
* OK - request has been processed
* FAULT - internal error which results closing of the request and creation of its copy with a new ID
* FALSE - shouldn't occur
* WORK - shouldn't occur

Here is quotes from bot@yandex-team.ru mailing list:

NEW - завяка открыта. Тут надо понимать, что основная работа у группы ТО идет в параллельном инструменте (ОТРС),
поэтому заявка может висеть в статусе "новая" довольно долго по разным причинам. Система не позволит тебе создать
идентичную заявку в течение суток.
DELETED - тут может быть два варианта:
  1. Произошла ошибка при создании тикета в ОТРС. Заявка в боте считается "удаленной", надо снова сходить и отправить
     запрос спустя время.
  2. Заявка была отменена (см. https://wiki.yandex-team.ru/bot/api/feedback/).
FAULT - произошла беда с системой учета денег и оборудования (Оебс). Статус технический, т. к. человек все равно
пойдет до конца и все сделает. Номер заявки при этом сменится, т. к. с точки зрения системы его действия будут уже
другой задачей.
WORK - на данный момент технический статус, ты его в своих заявках не увидишь. TimeFinish при этом означает время
последней активности по задаче.
OK - успешное завершение работы.

> Вот отправлю я вам заяку починить IPMI на машине, и вы обнаружите, что по какой-то причине не сможете его починить
> (сдохла тушка, еще что-то): какой статус тогда получит заявка?
Ты получишь статус ОК и текстовое резюме (ResultComment). В резюме может быть сказано, что тушка нуждается в замене.
Для этого в БОТ будет создана другая задача, т.к. текущая - проверить ipmi - выполнена.

> А есть какая-либо ручка, через которую я смогу получить реальный статус зависшей NEW заявки? Я так понимаю, тут
> проблема в том, что “довольно долго” может превратиться во “всегда”.
Реального статуса не существует, т. к. люди фактически работают с ОТРС, где переписываются, закрывают-переоткрывают,
передают задачи, а Бот служит для технической поддержки людей, частично компенсируя низкую интеграцию ОТРС в нашу
инфраструктуру и рабочие процессы, и, относительно недавно, начал предоставлять некую отчетность, в т. ч. эти статусы.

Если при создании заявки выясняется, что уже есть открытая заявка с такими же параметрами, и она не очень старая
(сутки-двое), то новая заявка не создается, а возвращается ID уже существующей (вне зависимости от того, совпадают ли
инициаторы заявок или нет).


Request Patterns can be found here:
https://bot.yandex-team.ru/adm/js/request_patterns.php

"""
