from sepelib.core.exceptions import LogicalError
from walle.projects import RepairRequestSeverity
from walle.scenario.constants import ScriptName
from walle.scenario.scenario import Scenario


class RequestSource:
    EINE = "eine"
    BOT = "bot"


class BotTag:
    HIGH = "high"
    MEDIUM = "medium"
    LOW = "low"


class EineTag:
    HIGH = "eaas:high"
    MEDIUM = "eaas:medium"
    LOW = "eaas:low"

    ALL = [HIGH, MEDIUM, LOW]


def get_eine_tag_by_repair_request_severity(repair_request_severity: str) -> str:
    if RepairRequestSeverity.HIGH == repair_request_severity:
        return EineTag.HIGH
    elif RepairRequestSeverity.LOW == repair_request_severity:
        return EineTag.LOW
    return EineTag.MEDIUM


def admin_request_severity_tag_factory(host, request_source):
    if request_source == RequestSource.BOT:
        tag_enum = BotTag
    elif request_source == RequestSource.EINE:
        tag_enum = EineTag
    else:
        raise LogicalError()

    if host.scenario_id:
        scenario = Scenario.objects.get(scenario_id=host.scenario_id)
        if scenario.scenario_type not in ScriptName.WITH_PROJECT_REQUEST_SEVERITY:
            return tag_enum.LOW

    project = host.get_project()

    if RepairRequestSeverity.HIGH == project.repair_request_severity:
        return tag_enum.HIGH
    elif RepairRequestSeverity.LOW == project.repair_request_severity:
        return tag_enum.LOW
    return tag_enum.MEDIUM
