import hashlib
import hmac

from sepelib.core import config
from walle.errors import UnauthenticatedError


def get_csrf_token(session_id):
    """Returns a CSRF token for the specified session ID."""

    return hmac.new(
        key=str.encode(config.get_value("authorization.csrf_key")), msg=str.encode(session_id), digestmod=hashlib.sha1
    ).hexdigest()


def check_csrf_token(session_id, request):
    try:
        token = request.headers["X-Csrf-Token"]
    except KeyError:
        raise UnauthenticatedError("CSRF token must be specified.")

    if token != get_csrf_token(session_id):
        raise UnauthenticatedError("Invalid CSRF token.")
