from sepelib.core import config
from sepelib.core.exceptions import LogicalError

from walle.constants import EMAIL_DOMAIN

ISSUER_WALLE = "wall-e"
ISSUER_ROBOT_WALLE = "robot-walle"
ISSUER_ANONYMOUS_USER = "api"
ISSUER_IDM = "idm"
ISSUER_SCOPE = "walle:api"


def is_user(issuer):
    """Returns True if the specified issuer is a real Staff user - not a virtual one."""

    return issuer.endswith("@")


def is_admin(login):
    """Returns True if the specified user is admin."""

    return login in config.get_value("authorization.admins")


def get_issuer_login(issuer):
    """Returns login of the specified issuer."""

    if not is_user(issuer):
        raise LogicalError()

    return issuer[:-1]


def get_login_email(login):
    """Returns email of the specified login."""

    return login + "@" + EMAIL_DOMAIN


def get_user_email(issuer):
    """Returns issuer email or None if he doesn't have a email."""

    return issuer + EMAIL_DOMAIN if is_user(issuer) else None


def get_issuer_name(issuer):
    """Returns human name of the specified issuer."""

    if issuer == ISSUER_WALLE:
        return "Wall-E"
    elif issuer == ISSUER_ANONYMOUS_USER:
        return "An unauthorized API user"
    else:
        return issuer
