import logging
import re

from walle.clients.staff import batch_get_groups_members
from walle.idm.role_storage import IDMRoleMembership
from walle.util import cert

log = logging.getLogger(__name__)
CERTIFICATE_EXPIRATION_WARN_DAYS = 30  # it takes some time and people might be on vacation


def preheat_group_members_cache():
    try:
        groups = _get_all_group_owners()
        batch_get_groups_members(groups, allow_robots=False)
    except Exception:
        log.exception("Got exception while preheating group members cache:")
        return False


def _get_all_group_owners():
    group_owners = IDMRoleMembership.objects(member=re.compile(r"^@")).distinct("member")
    return tuple(sorted(set(group_owners)))


def check_certificate_date():
    try:
        cert.notify_if_cert_expires_soon(
            "CAuth", "cauth.cert_path", "cauth-certificate-expires", CERTIFICATE_EXPIRATION_WARN_DAYS
        )
    except:
        log.exception("Failed to check certificate expiration date")
        return False
