import dataclasses
import typing as tp

from sepelib.core import config
from walle.clients.utils import json_request
from walle.expert.decisionmakers import Decision
from walle.hosts import Host
from walle.util.misc import drop_none


@dataclasses.dataclass(frozen=True, eq=True)
class AlternateDecisionParams:
    checks: set[str]
    checks_for_use: list[str]


@dataclasses.dataclass(frozen=True, eq=True)
class DecisionParams:
    checks: set[str]


def get_decisions_from_handler(
    host: Host,
    alternate_decision_params: tp.Optional[AlternateDecisionParams] = None,
    decision_params: tp.Optional[DecisionParams] = None,
):
    url = config.get_value("decision_handler.url").format(host.uuid)
    data = dict()
    if alternate_decision_params:
        data["alternate_decision_args"] = drop_none(
            {
                "include": True,
                "checks": list(alternate_decision_params.checks) if alternate_decision_params.checks else None,
                "checks_for_use": list(alternate_decision_params.checks_for_use)
                if alternate_decision_params.checks_for_use
                else None,
            }
        )
    if decision_params:
        data["decision_args"] = drop_none(
            {
                "include": True,
                "checks": list(decision_params.checks) if decision_params.checks else None,
            }
        )
    result = json_request("dmc.make_decision", "POST", url, data=data)

    alternate_decision, decision = None, None
    if alternate_decision_params:
        alternate_decision = Decision(**result["alternate_decision"])
    if decision_params:
        decision = Decision(**result["decision"])
    return alternate_decision, decision
