import typing as tp

from walle import yc, boxes
from . import interface, slayer_dns_api, rurikk_dns_api


def get_client(box_id: tp.Optional[str], dns_zone_id: tp.Optional[str]) -> interface.DnsClientInterface:
    box_config = boxes.get_dns_box_config(box_id)
    if box_config is None or box_config.type == yc.DnsApiType.slayer_dns or not dns_zone_id:
        return slayer_dns_api.DnsClient()
    else:
        return rurikk_dns_api.RurikkDnsClient(
            key_id=box_config.key_id,
            service_account_id=box_config.service_account_id,
            private_key=box_config.private_key,
            dns_zone_id=dns_zone_id,
            dns_endpoint=box_config.dns_endpoint,
            iam_endpoint=box_config.iam_endpoint,
        )
