"""Wall-e credentials in different systems"""


from mongoengine import StringField

from sepelib.core import constants
from walle.models import Document
from walle.util.cache import cached_with_exceptions

_SSH_CREDENTIALS_ID = "ssh-credentials"


class Credentials(Document):
    crd_id = StringField(primary_key=True, required=True, help_text="Credentials identifier")
    public = StringField(help_text="Public identifier (username)")
    private = StringField(required=True, help_text="Private identifier (password / token)")


@cached_with_exceptions(value_ttl=constants.HOUR_SECONDS, error_ttl=constants.MINUTE_SECONDS)
def get_ssh_credentials():
    """Return global ssh credentials."""

    return Credentials.objects.get(crd_id=_SSH_CREDENTIALS_ID)
