from walle.application import app
from walle.util.cron import CronJobKnownError


class ConfigRedefinitionError(CronJobKnownError):
    """There are some config redefinition"""


class ActiveDmcRulesError(CronJobKnownError):
    """There are some active DMC rules"""


def _start_config_monintoring():
    settings = app.settings()
    if settings.checks_percentage_overrides:
        raise ConfigRedefinitionError(str(settings.checks_percentage_overrides))

    if settings.global_timed_limits_overrides:
        raise ConfigRedefinitionError(str(settings.global_timed_limits_overrides))
