import logging

from walle.clients.network import racktables_client
from walle.hosts import Host, InfinibandInfo

log = logging.getLogger(__name__)


def _infiniband_info_sync():
    actual_hosts_info = racktables_client.get_hosts_infiniband_info()
    updated_hosts = set()
    db_hosts = {
        h.name: h
        for h in Host.objects(infiniband_info__exists=True).only(Host.name.db_field, Host.infiniband_info.db_field)
    }
    for db_host in db_hosts.values():
        if actual_info := actual_hosts_info.get(db_host.name):
            updated_hosts.add(db_host.name)
            if db_host.infiniband_info.has_changes(actual_info):
                log.info(f"Update infiniband info '{actual_info}'.")
                Host.objects(name=db_host.name).update_one(
                    set__infiniband_info=InfinibandInfo.from_racktables_info(actual_info)
                )
        else:
            log.info(f"Remove infiniband info '{db_host.infiniband_info}' for {db_host.name}.")
            db_host.modify(unset__infiniband_info=True)
    for updated_host in set(actual_hosts_info) - updated_hosts:
        new_info = actual_hosts_info[updated_host]
        log.info(f"Add infiniband info '{new_info}'.")
        Host.objects(name=updated_host).update_one(set__infiniband_info=InfinibandInfo.from_racktables_info(new_info))
