"""Syncs Wall-E database with databases of its development stands."""

import logging

from walle_api.client import WalleClient

from sepelib.core import config, constants
from walle import constants as walle_constants
from walle.hosts import HostState
from walle.util import db_cache
from walle.util.gevent_tools import gevent_idle_iter

log = logging.getLogger(__name__)


def _sync_development_stands():
    for stand_name, stand_config in config.get_value("development_stands").items():
        try:
            _sync_hosts(stand_name, stand_config["url"])
        except Exception as e:
            log.error("Failed to sync host database with '%s' stand: %s", stand_name, e)


def _sync_hosts(stand_name, api_url):
    client = WalleClient(api_url, name="Wall-E/" + walle_constants.version)
    assigned_hosts = client.iter_hosts(state=HostState.ALL_ASSIGNED, fields=["name"])
    stand_hosts = [host["name"] for host in gevent_idle_iter(assigned_hosts)]
    db_cache.set_value("stand_hosts:" + stand_name, stand_hosts, ttl=constants.DAY_SECONDS)
    log.info("Synced %s hosts from '%s' stand.", len(stand_hosts), stand_name)
