"""Syncs Wall-E database with Einstellung."""

import logging

import walle.hosts
from walle.clients import eine
from walle.constants import NETWORK_SOURCE_EINE, HOST_TYPES_WITH_PARTIAL_AUTOMATION
from walle.host_network import get_host_network_map, HostNetwork
from walle.hosts import Host, HostStatus
from walle.util.gevent_tools import gevent_idle_iter
from walle.util.mongo import SECONDARY_LOCAL_DC_PREFERRED

log = logging.getLogger(__name__)


def db_sync_eine_netmap():
    try:
        _sync()
    except Exception:
        log.exception("Failed to sync host network location info from eine:")
        return False


def _sync():
    eine_client = eine.get_client(eine.get_eine_provider(box_id=None))
    network_map = {None: eine_client.get_network_map()}
    hosts = Host.objects(
        status__ne=HostStatus.INVALID,
        type__in=HOST_TYPES_WITH_PARTIAL_AUTOMATION,
        read_preference=SECONDARY_LOCAL_DC_PREFERRED,
    ).only("uuid", "inv", "name", "project", "location")
    host_network_mac = get_host_network_map()
    for host in gevent_idle_iter(hosts):
        box_id = host.get_eine_box()
        if box_id not in network_map:
            eine_client = eine.get_client(eine.get_eine_provider(box_id))
            network_map[box_id] = eine_client.get_network_map()
        try:
            switch_info, macs_info = network_map[box_id][host.inv]
        except KeyError:
            continue

        try:
            host_network = host_network_mac[host.uuid]
        except KeyError:
            host_network = HostNetwork.get_or_create(host.uuid)

        if switch_info is not None:
            walle.hosts.update_network_location(
                host, host_network, switch_info.switch, switch_info.port, switch_info.timestamp, NETWORK_SOURCE_EINE
            )

        if macs_info is not None:
            walle.hosts.update_eine_active_mac(host, host_network, macs_info.active, macs_info.timestamp)
