# flake8: noqa


from .global_automation import GLOBAL_HEALING_AUTOMATION, GLOBAL_DNS_AUTOMATION
from .project_automation import PROJECT_HEALING_AUTOMATION, PROJECT_DNS_AUTOMATION, HealingAutomation, DnsAutomation
from .automation_context import (
    AutomationContext,
    AutomationDisabledError,
    AutomationDisabledGloballyError,
    AutomationDisabledForProjectError,
)


def healing_automation(project_id, plot=None):
    return AutomationContext(project_id, GLOBAL_HEALING_AUTOMATION, PROJECT_HEALING_AUTOMATION, automation_plot=plot)


def dns_automation(project_id):
    return AutomationContext(project_id, GLOBAL_DNS_AUTOMATION, PROJECT_DNS_AUTOMATION)
