import enum


@enum.unique
class FailureType(str, enum.Enum):
    BMC_IPMI = "bmc_ipmi"
    BMC_IP_DNS = "bmc_ip_dns"
    BMC_BATTERY = "bmc_battery"
    BMC_VOLTAGE = "bmc_voltage"
    BMC_OTHER = "bmc_other"

    LINK_MALFUNCTION = "link_malfunction"
    LINK_RX_CRC_ERRORS = "link_rx_crc_errors"

    ECC = "ecc"
    MEM_ECC = "mem_ecc"
    MEM_SIZE = "mem_size"
    MEM_NUMA = "mem_numa"
    MEM_SPEED = "mem_speed"

    DISK_CONNECTIVITY = "disk_bad_cable"
    DISK_PERFORMANCE = "disk_performance"
    DISK_BAD_BLOCKS = "disk_bad_blocks"
    DISK_NVME_MISSING = "disk_nvme_missing"
    DISK_NVME_LINK_DEGRADED = "disk_nvme_link_degraded"
    DISK_UNKNOWN = "disk_unknown"
    DISK_NO_CHECK_INFO = "disk_no_check_info"
    DISK_COMMON = "disk_common"
    SSD_PERF_RAND_TOO_LOW = "ssd_perf_rand_too_low"

    DISK_DRIVE_SMART_RSEC_ERROR = "disk_drive_smart_rsec"
    DISK_DRIVE_SMART_REVENT_ERROR = "disk_drive_smart_revent"
    DISK_DRIVE_SMART_OFFUNC_ERROR = "disk_drive_smart_offunc"
    DISK_DRIVE_SMART_PEND_SEC_ERROR = "disk_drive_smart_pend_sec"
    DISK_DRIVE_SMART_DISK_FAILING_ERROR = "disk_drive_smart_disk_failing"
    DISK_DRIVE_SMART_OPEN_FAILED_ERROR = "disk_drive_smart_open_failed"
    DISK_DRIVE_SMART_SELFTEST_FAILED_ERROR = "disk_drive_smart_selftest_failed"
    DISK_DRIVE_SMART_UNK_ERROR_ERROR = "disk_drive_smart_unk_error"

    GPU_MISSING = "gpu_missing"
    GPU_AVAILABILITY = "gpu_availability"
    GPU_OVERHEAT = "gpu_overheat"
    GPU_CAPPING = "gpu_capping"
    GPU_BANDWIDTH_TOO_LOW = "gpu_bandwidth_too_low"
    GPU_RETIRED_PAGES = "gpu_retired_pages"
    GPU_INFOROM_CORRUPTED = "gpu_inforom_corrupted"
    GPU_POWER_CAPPING = "gpu_power_capping"
    GPU_RETIRED_PAGES_PENDING = "gpu_retired_pages_pending"
    GPU_P2P_FAILED = "gpu_p2p_failed"
    GPU_POWER_UNKNOWN = "gpu_power_unknown"
    GPU_HANG = "gpu_hang"

    INFINIBAND_MISMATCH = "infiniband_mismatch"
    INFINIBAND_INVALID_PHYS_STATE = "infiniband_invalid_phys_state"
    PCIE_DEVICE_BANDWIDTH_TOO_LOW = "pcie_device_bandwidth_too_low"
    INFINIBAND_ERR = "infiniband_err"
    INFINIBAND_MISCONFIGURED = "infiniband_misconfigured"
    INFINIBAND_INVALID_STATE = "infiniband_invalid_state"
    INFINIBAND_LOW_SPEED = "infiniband_low_speed"

    CPU_FAILURE = "cpu_failure"
    CPU_CAPPED = "cpu_capped"
    CPU_OVERHEATED = "cpu_overheated"
    CPU_SYSTEM_MISCONFIGURED = "cpu_system_misconfigured"

    AVAILABILITY = "availability"
    MISSING_PASSIVE_CHECKS = "missing_passive_checks"
    KERNEL_TAINTED = "kernel_tainted"
    MANY_REBOOTS = "many_reboots"
    FS_CHECK = "fs_check"
    UPLINK_COMMON = "uplink_common"

    RACK_OVERHEAT = "rack_overheat"
    RACK_COMMON = "rack_common"

    SECOND_TIME_NODE = "2nd_time_node"
    DEFAULT = "default"
