# flake8: noqa

"""Contains logic for making a decision about what to do with host if it has a failure."""


from .availability_check import AvailabilityCheckRule
from .missing_passive_checks_rule import MissingPassiveChecksRule
from .base import SingleCheckRule
from .configurable import configure_rule
from .hw_watcher_rules import (
    CheckDisk,
    CheckDiskPerformance,
    CheckDiskBadBlocks,
    CheckSsdPerfLow,
    CheckDiskCable,
    CheckDiskSmartCodesRule,
    CheckLink,
    CheckMemory,
    CheckBmcIpDns,
    CheckBmcBattery,
    CheckBmcUnknown,
    CheckBmcIpmi,
    CheckBmcVoltage,
    CheckGpu,
    CheckCpuCaches,
    CheckCpuThermalHWW,
    CheckInfiniband,
)
from .walle_check_rules import CheckTaintedKernel, CheckCpu, CheckCpuCapping, FsckRule, CheckReboots, TorLinkRule
from .walle_ib_link_rule import IbLinkRule
from .walle_rack_rules import RackRule, RackOverheatRule
from .meta_rules import MissingHwChecksRule
