""""hw_watcher rules common utilities."""

import logging

from walle.expert.decision import Decision
from walle.expert.rules.escalation import Predicate

log = logging.getLogger(__name__)


def get_reason_from_hw_watcher(check_name, hw_watcher_reasons):
    reason = "{} check failed. hw-watcher:".format(check_name)

    if len(hw_watcher_reasons) == 1:
        reason += " " + hw_watcher_reasons[0]
        if reason[-1] != ".":
            reason += "."
    else:
        reason += "\n" + "\n".join("* " + error for error in hw_watcher_reasons)

    return reason


def get_hw_watcher_result(check_result):
    metadata = check_result["metadata"]
    if "result" in metadata:
        return metadata["result"]
    return None


def get_eine_code(hw_watcher_reasons):
    return hw_watcher_reasons.get("eine_code", None) or None


def operation_match(operation):
    """
    Create predicate that checks if decision's action matches with required action.

    :type operation: Operation
    :rtype: Predicate
    """
    return Predicate(lambda decision: decision.params.get("operation") == operation.type)


def decision_unsupported_eine_code(host, check_type, unsupported_codes):
    codes_str = ", ".join(sorted(unsupported_codes))
    log.error("Unsupported eine_codes host %s check {}: {}".format(check_type, codes_str), host.human_name())

    return Decision.healthy("Check has unknown failures: eine_codes {}".format(codes_str), checks=[check_type])


def decision_unsupported_failure(host, check_type, reason_str):
    log.error("Unsupported failure host %s check {}: %s".format(check_type), host.human_name(), reason_str)
    return Decision.healthy("The host doesn't have any known errors.", checks=[check_type])
