"""Garbage collector for failure reports."""


from sepelib.core import constants

from walle.failure_reports import observers
from walle.failure_reports.base import ErrorReportModel, ReportPublisher, ErrorHostsReport, StreamKey, RotationStrategy
from walle.models import timestamp


def gc_reports():
    last_update = timestamp() - constants.DAY_SECONDS

    for report in ErrorReportModel.opened(last_update):
        stream_key = StreamKey.from_wrapped_key(report.stream_key)
        publisher = ReportPublisher.by_stream_key(stream_key)
        rotation_strategy = RotationStrategy.by_name(stream_key.rotation_strategy_name)
        observers_group = observers.collect_group(stream_key)

        report = ErrorHostsReport(
            stream_key.wrapped_key(),
            publisher,
            rotation_strategy,
            observers_group,
            raise_on_failure=False,
            dry_run=False,
        )
        with report:
            # make report processor close old reports but do not set content for new reports
            # so that it does not create nor update any other reports.
            pass
