"""Cancels all created admin requests for the host."""

import logging

import walle.admin_requests.request as admin_requests
from sepelib.core import config
from walle.fsm_stages.common import register_stage, complete_current_stage
from walle.stages import Stages

log = logging.getLogger(__name__)


def _cancel_admin_requests(host):
    if config.get_value("hardware.enable_admin_requests"):
        admin_requests.cancel_all_by_host(host.inv, name=host.name)

    complete_current_stage(host)


register_stage(Stages.CANCEL_ADMIN_REQUESTS, _cancel_admin_requests)
