import walle.tasks

from walle import audit_log
from walle.authorization import ISSUER_WALLE
from walle.clients.eine import ProfileMode
from walle.fsm_stages.common import complete_current_stage, get_current_stage, register_stage
from walle.stages import Stages


def _profile_or_redeploy_if_needed(host):
    stage = get_current_stage(host)
    need_profile = stage.get_param("profile_after_task", False)
    need_redeploy = stage.get_param("redeploy_after_task", False)

    if not need_profile and not need_redeploy:
        return False

    audit_log.complete_task(host.task)
    cms_task_id = host.task.cms_task_id

    if need_redeploy:
        walle.tasks.schedule_redeploy(
            ISSUER_WALLE,
            host.task.type,
            host,
            custom_profile_mode=(ProfileMode.DEFAULT if need_profile else None),
            from_current_task=True,
            cms_task_id=cms_task_id,
        )
    else:
        walle.tasks.schedule_profile(
            ISSUER_WALLE, host.task.type, host, from_current_task=True, cms_task_id=cms_task_id
        )
    return True


def _handle(host):
    if _profile_or_redeploy_if_needed(host):
        return
    complete_current_stage(host)


register_stage(Stages.CLOUD_POST_PROCESSOR, handler=_handle)
