"""Host deletion stage."""

import logging

from walle.fsm_stages.common import (
    register_stage,
    terminate_current_stage,
    commit_stage_changes,
    generate_stage_handler,
)
from walle.network import get_free_host_name_template, BlockedHostName
from walle.stages import Stages, StageTerminals

log = logging.getLogger(__name__)


_STATUS_BLOCKING_HOST_NAME = "blocking-hostname"
_STATUS_DELETING_HOST = "deleting-host"


def _handle_block_hostname(host):
    name_template = get_free_host_name_template()
    if host.name and not name_template.fqdn_matches(host.name):
        BlockedHostName.store(host.name)

    commit_stage_changes(host, status=_STATUS_DELETING_HOST, check_now=True)


def _handle_delete_host(host):
    terminate_current_stage(StageTerminals.DELETE_HOST, host)


# Attention: this stage removes host from database.
register_stage(
    Stages.COMPLETE_DELETION,
    generate_stage_handler(
        {
            _STATUS_BLOCKING_HOST_NAME: _handle_block_hostname,
            _STATUS_DELETING_HOST: _handle_delete_host,
            # Transition
            None: _handle_block_hostname,
        }
    ),
)
