"""Completes host preparing by switching it from free to assigned state."""

import logging

import walle.tasks
from sepelib.core.exceptions import Error
from walle.fsm_stages.common import register_stage, get_current_stage, complete_current_stage
from walle.stages import Stages
from walle.util.misc import fix_mongo_set_kwargs

log = logging.getLogger(__name__)


def _complete_preparing(host):
    stage = get_current_stage(host)

    if stage.has_param("restrictions"):
        restrictions = stage.get_param("restrictions")
    else:
        restrictions = host.get_project(fields=["default_host_restrictions"]).default_host_restrictions

    updated = host.modify(
        walle.tasks.host_query(host),
        **fix_mongo_set_kwargs(
            set__provisioner=stage.get_param("provisioner", None),
            set__config=stage.get_param("config", None),
            set__deploy_config_policy=stage.get_param("deploy_config_policy", None),
            set__deploy_tags=stage.get_param("deploy_tags", None) or None,
            set__deploy_network=stage.get_param("deploy_network", None),
            set__restrictions=restrictions or None,
            set__extra_vlans=stage.get_param("extra_vlans", None),
            inc__task__revision=1,
        )
    )

    if not updated:
        raise Error("Unable to commit host state change: it doesn't have an expected state already.")

    complete_current_stage(host)


register_stage(Stages.COMPLETE_PREPARING, _complete_preparing)
