"""Completes host releasing by switching it to free state."""

import logging

import walle.tasks
from sepelib.core.exceptions import Error
from walle.fsm_stages.common import register_stage, complete_current_stage
from walle.hosts import Host, HostState
from walle.stages import Stages

log = logging.getLogger(__name__)


def _complete_releasing(host):
    update = {"unset__" + field: True for field in Host.release_fields}
    update.update(
        inc__task__revision=1,
        **Host.set_state_kwargs(HostState.FREE, issuer=host.task.owner, audit_log_id=host.task.audit_log_id)
    )

    updated = host.modify(walle.tasks.host_query(host), **update)
    if not updated:
        raise Error("Unable to commit host state change: it doesn't have an expected state already.")

    complete_current_stage(host)


register_stage(Stages.COMPLETE_RELEASING, _complete_releasing)
