"""Host deactivation stage."""


from walle import audit_log
from walle.fsm_stages.common import register_stage, deactivate, get_current_stage
from walle.stages import Stages
from walle.util import notifications
from walle.util.tasks import on_finished_task


def _handle(host):
    issuer = audit_log.get_task_issuer(host.task)
    reason = "Host deactivation has been requested by {}: {}.".format(
        "[unknown]" if issuer is None else issuer, get_current_stage(host).get_param("reason", "[no reason provided]")
    )

    prev_host = host.copy()
    deactivate(host, reason=reason)

    audit_log.complete_task(prev_host.task)
    notifications.on_dead_host(prev_host, reason)
    on_finished_task(prev_host)


# Attention: this stage terminates task processing, so it must be the last stage in task
register_stage(Stages.DEACTIVATE, _handle)
