"""Stages that can be used to run fsm tasks without really doing things to hosts."""
from walle.fsm_stages.common import get_current_stage, commit_stage_changes, register_stage, complete_current_stage
from walle.stages import Stages

_DEFAULT_PERIOD = 5


def foo_stage(host):
    _foobar_stage_impl(host, "doing-foo")


def bar_stage(host):
    _foobar_stage_impl(host, "doing-bar")


def _foobar_stage_impl(host, default_label):
    stage = get_current_stage(host)
    need_repeats = stage.get_param("repeat", 1)
    repeats = stage.get_temp_data("repeats", 0)
    period = stage.get_temp_data("period", _DEFAULT_PERIOD)

    label = stage.get_param("label", default_label)
    if repeats < need_repeats:
        stage.set_temp_data("repeats", repeats + 1)
        commit_stage_changes(host, status=label, check_after=period)
    else:
        complete_current_stage(host)


register_stage(Stages.FOO, foo_stage)
register_stage(Stages.BAR, bar_stage)
