"""Logs completion of the specified operation to operation log."""

import logging

import walle.operations_log.operations as operations
from walle.fsm_stages.common import register_stage, get_current_stage, complete_current_stage
from walle.stages import Stages

log = logging.getLogger(__name__)


def _log_completed_operation(host):
    stage = get_current_stage(host)

    operation_type = stage.get_param("operation")
    params = stage.get_param("params", None)

    operations.on_completed_operation(host, operation_type, params)
    complete_current_stage(host)


register_stage(Stages.LOG_COMPLETED_OPERATION, _log_completed_operation)
