"""Report Rack is a stage that creates startrek reports about rack overheat."""


from walle.failure_reports.rack_reports import get_report
from walle.fsm_stages import startrek_report
from walle.fsm_stages.common import register_stage
from walle.stages import Stages


def _handler(host):
    handler = startrek_report.ReportStageHandler(host, _report_getter)
    handler.handle()


def _report_getter(handler):
    location = handler.host.location
    return get_report(
        location,
        error="CPU overheating",
        error_short="overheating",
        error_link="https://wiki.yandex-team.ru/einstellung/errorcodes/CPU_OVERHEATING",
        solution_short="Check the cooling ASAP.",
    )


register_stage(Stages.REPORT_RACK_OVERHEAT, _handler)
