"""Report Rack is a stage that creates startrek reports about rack failures."""


from walle.failure_reports.rack_reports import get_report
from walle.fsm_stages import startrek_report
from walle.fsm_stages.common import register_stage
from walle.stages import Stages


def _handler(host):
    handler = startrek_report.ReportStageHandler(host, _report_getter)
    handler.handle()


def _report_getter(handler):
    location = handler.host.location
    return get_report(
        location,
        error="unavailable",
        error_short="unavailable",
        error_link="https://wiki.yandex-team.ru/einstellung/errorcodes/Rack_unavailable",
        solution_short="Check power ASAP.",
    )


register_stage(Stages.REPORT_RACK, _handler)
