"""Contains all logic for resetting BMC controller via IPMI-Proxy front-end API."""

import logging

from walle.fsm_stages.common import register_stage, complete_current_stage
from walle.stages import Stages

log = logging.getLogger(__name__)


def _bmc_reset_handler(host):
    # We do not get lots of useful feedback here, actually.
    ipmi_client = host.get_ipmi_client()
    ipmi_client.bmc_reset(ipmi_client.BMC_RESET_COLD)

    log.info("Host %s bmc has been reset.", host.human_id())
    return complete_current_stage(host)


register_stage(Stages.RESET_BMC, _bmc_reset_handler)
