"""
Resets host's health status in such a way that all checks that were processed before this time will be considered as
outdated.
"""

import logging

from sepelib.core.exceptions import LogicalError
from walle.fsm_stages.common import register_stage, commit_stage_changes, complete_current_stage
from walle.hosts import HostState
from walle.models import timestamp
from walle.stages import Stages

log = logging.getLogger(__name__)


def _reset_health_status(host):
    if host.state in HostState.ALL_ASSIGNED:
        current_timestamp = timestamp()
        host.checks_min_time = current_timestamp
        commit_stage_changes(host, extra_fields=["checks_min_time"])
    elif host.state == HostState.FREE:
        pass
    else:
        raise LogicalError()

    complete_current_stage(host)


register_stage(Stages.RESET_HEALTH_STATUS, _reset_health_status)
