from enum import Enum

from walle import projects


class PlatformProblems(Enum):
    POST_MEMORY_PROBLEM = 'post_memory_problem'
    POST_UNKNOWN = 'post_code_unknown'
    POST_OK = 'post_ok'


class Platform:
    system = None
    board = None

    def __init__(self, host):
        self.fqdn = host.name
        self.host_project = host.project
        if not self.board:
            self.board = host.platform.board
        if not self.system:
            self.system = host.platform.system

    def __str__(self):
        return "Platform({}/{}: {})".format(self.board, self.system, self.fqdn)

    def get_current_post_code(self, ipmi_client):
        return None

    def get_post_problem_for_code(self, code):
        return None

    def get_platform_specific_eine_tags(self) -> set[str]:
        return set()

    def provides_post_code(self):
        return False

    def ipxe_supported(self):
        return projects.ipxe_support_enabled(self.host_project)

    def need_service_network_for_pxe(self):
        return False
