from walle.host_platforms.platform import Platform
from walle.clients.eine import EineProfileTags


class Platform1DHV2402(Platform):
    system = "1D-HV24-02"

    def __init__(self, host):
        super().__init__(host)

    def get_platform_specific_eine_tags(self) -> set[str]:
        return {EineProfileTags.SKIP_FW_FANTABLE}


class Platform1DHV2608(Platform):
    system = "1S-HV26-08"

    def __init__(self, host):
        super().__init__(host)

    def get_platform_specific_eine_tags(self) -> set[str]:
        return {EineProfileTags.SKIP_FW_FANTABLE}


def register_aic_platforms(registry):
    registry.register_platform(Platform1DHV2402)
    registry.register_platform(Platform1DHV2608)
