from walle.host_platforms.platform import Platform


class PlatformASUSZ9PGD16(Platform):
    system = "ESC4000-FDR G2S"
    board = "Z9PG-D16"

    def __init__(self, host):
        super().__init__(host)

    def ipxe_supported(self):
        return False


class PlatformASUSZ9PGD16G2(Platform):
    system = "ESC4000 G2"
    board = "Z9PG-D16 Series"

    def __init__(self, host):
        super().__init__(host)

    def ipxe_supported(self):
        return False


class PlatformASUSKGPED16(Platform):
    system = "KGPE-D16"

    def ipxe_supported(self):
        return False


class PlatformASUSESC4000(Platform):
    system = "ESC4000"

    def ipxe_supported(self):
        return False


def register_asus_platforms(registry):
    registry.register_platform(PlatformASUSZ9PGD16)
    registry.register_platform(PlatformASUSZ9PGD16G2)
    registry.register_platform(PlatformASUSKGPED16)
    registry.register_platform(PlatformASUSESC4000)
