from walle.host_platforms.platform import Platform


class BasePlatformWithoutIpxe(Platform):
    def ipxe_supported(self):
        return False


class PlatformQuantaR210MB2MS(BasePlatformWithoutIpxe):
    system = "R210-MB2MS"
    board = "R210-MB2MS"


class PlatformTECAL(Platform):
    system = "TECAL RH1285"
    board = "TECAL RH1285"

    def need_service_network_for_pxe(self):
        return True


class PlatformPROLIANT(Platform):
    system = "PROLIANT DL160G6"
    board = "PROLIANT DL160G6"

    def need_service_network_for_pxe(self):
        return True


class PlatformSYS(BasePlatformWithoutIpxe):
    system = "SYS-6016T-NTF"
    board = "SYS-6016T-NTF"


class PlatformRS500(BasePlatformWithoutIpxe):
    system = "RS500-E6/PS4"
    board = "RS500-E6/PS4"


class PlatformSYS7049GPTRT(BasePlatformWithoutIpxe):
    system = "SYS-7049GP-TRT"


class PlatformS2P2CB7Q(BasePlatformWithoutIpxe):
    system = "S2P2CB7Q"


class PlatformAS1022GNTF(BasePlatformWithoutIpxe):
    system = "AS-1022G-NTF"


def register_quanta_platforms(registry):
    registry.register_platform(PlatformQuantaR210MB2MS)
    registry.register_platform(PlatformPROLIANT)
    registry.register_platform(PlatformSYS)
    registry.register_platform(PlatformTECAL)
    registry.register_platform(PlatformRS500)
    registry.register_platform(PlatformSYS7049GPTRT)
    registry.register_platform(PlatformS2P2CB7Q)
    registry.register_platform(PlatformAS1022GNTF)
