from walle.host_platforms.platform import Platform


class PlatformX8DTIF(Platform):
    system = "X8DTI-F"

    def ipxe_supported(self):
        return False


class PlatformX9DRW3F(Platform):
    system = "X9DRW-3F"


class PlatformX9DRWIF(Platform):
    system = "X9DRW-IF"


class PlatformX10DRWI(Platform):
    system = "X10DRW-I"


def register_supermicro_platforms(manager):
    manager.register_platform(PlatformX8DTIF)
    manager.register_platform(PlatformX9DRW3F)
    manager.register_platform(PlatformX9DRWIF)
    manager.register_platform(PlatformX10DRWI)
