"""Host's timestamp configuration for metrics collection."""

import logging

import enum

from mongoengine import LongField, StringField

from sepelib.mongo.util import register_model
from walle.models import Document, timestamp
from walle.util.cloud_tools import get_tier

log = logging.getLogger(__name__)


class HostShardType(str, enum.Enum):
    screening = "screening"
    triage = "triage"


@register_model
class HostShard(Document):
    shard_id = LongField(required=True)
    tier = StringField(help_text="Shard's tier")
    type = StringField(help_text="Shard's type")
    processing_time = LongField(required=True, help_text="Time when shard was processing")

    meta = {
        "collection": "host_shard",
    }

    @staticmethod
    def processed(shard_id, type_: HostShardType):
        processing_time = timestamp()
        HostShard.get_collection().replace_one(
            {
                "shard_id": int(shard_id),
                "tier": get_tier(),
                "type": type_.value,
            },
            {
                "shard_id": int(shard_id),
                "tier": get_tier(),
                "type": type_.value,
                "processing_time": processing_time,
            },
            upsert=True,
        )
