import logging

from sepelib.core import config
from walle.clients import idm, juggler
from walle.clients.juggler import JUGGLER_MSG_MAX_SIZE
from walle.util.text import shrink_string


log = logging.getLogger(__name__)


def report_idm_system_status():
    """Send system status in IDM to Juggler."""
    system_name = config.get_value("idm.system_name")
    event_name = "{}-idm-system-status".format(system_name)

    status = juggler.JugglerCheckStatus.OK
    message = "System {} is not broken in IDM".format(system_name)

    try:
        if idm.is_system_broken():
            status = juggler.JugglerCheckStatus.CRIT
            message = "System {} is broken in IDM".format(system_name)
    except Exception as e:
        log.exception("Got exception during IDM system check:")
        status = juggler.JugglerCheckStatus.WARN
        message = shrink_string("Got exception during IDM system check: {}".format(e), JUGGLER_MSG_MAX_SIZE)

    juggler.send_event(event_name, status, message)
