import typing

from walle.clients import abc
from walle.maintenance_plot.common_settings import MaintenanceApprovers
from walle.maintenance_plot.scenarios_settings.itdc_maintenance import ItdcMaintenanceMaintenancePlotSettings
from walle.maintenance_plot.scenarios_settings.noc_hard import NocHardMaintenancePlotSettings
from walle.scenario.constants import ScriptName

MAINTENANCE_PLOT_ID_REGEX = r"(^[a-z][a-z0-9]*(?:-[a-z0-9]+)*$)"

SCENARIO_TYPES_SETTINGS_MAP = {
    ScriptName.ITDC_MAINTENANCE: ItdcMaintenanceMaintenancePlotSettings,
    ScriptName.NOC_HARD: NocHardMaintenancePlotSettings,
}

SYSTEM_ADMINISTRATORS = MaintenanceApprovers(abc_role_scope_slugs=[abc.RoleScopeSlug.ADMINISTRATION])
HARDWARE_RESOURCE_OWNERS = MaintenanceApprovers(abc_roles_codes=[abc.Role.HARDWARE_RESOURCES_OWNER])
PRODUCT_HEAD = MaintenanceApprovers(abc_roles_codes=[abc.Role.PRODUCT_HEAD])

# Order matters.
DEFAULT_MAINTENANCE_APPROVERS: typing.List[MaintenanceApprovers] = [
    SYSTEM_ADMINISTRATORS,
    HARDWARE_RESOURCE_OWNERS,
    PRODUCT_HEAD,
]
