import typing

from walle.maintenance_plot.exceptions import MaintenancePlotNotFoundError, MaintenancePlotAlreadyExistError
from walle.maintenance_plot.model import (
    MAINTENANCE_PLOT_ID_TYPE,
    MaintenancePlot,
    MaintenancePlotMetaInfo,
    MaintenancePlotModel,
)


def get_maintenance_plot(plot_id, fields=None):
    try:
        return MaintenancePlotModel.with_fields(fields).get(id=plot_id)
    except MaintenancePlotModel.DoesNotExist:
        raise MaintenancePlotNotFoundError()


def get_all_maintenance_plots(fields):
    return MaintenancePlotModel.with_fields(fields)


def add_maintenance_plot_orm_object(maintenance_plot: MaintenancePlot):
    try:
        MaintenancePlotModel.objects.get(id=maintenance_plot.id)
        raise MaintenancePlotAlreadyExistError()
    except MaintenancePlotModel.DoesNotExist:
        pass

    maintenance_plot_orm_object = MaintenancePlotModel.from_dataclass(maintenance_plot)
    maintenance_plot_orm_object.save()


def delete_maintenance_plot(plot_id: MAINTENANCE_PLOT_ID_TYPE):
    maintenance_plot_orm_object = get_maintenance_plot_orm_object(plot_id)
    maintenance_plot_orm_object.delete()


def get_maintenance_plot_orm_object(plot_id: MAINTENANCE_PLOT_ID_TYPE) -> MaintenancePlotModel:
    try:
        return MaintenancePlotModel.objects.get(id=plot_id)
    except MaintenancePlotModel.DoesNotExist:
        raise MaintenancePlotNotFoundError()


def list_all_maintenance_plots_meta_infos(
    offset: int = 0, limit: int = 5
) -> typing.List[typing.Tuple[MAINTENANCE_PLOT_ID_TYPE, MaintenancePlotMetaInfo]]:
    return [
        (result.id, MaintenancePlotMetaInfo.from_dict(result.meta_info))
        for result in MaintenancePlotModel.objects[offset:limit].only("id", "meta_info")
    ]
