from walle.errors import ResourceAlreadyExistsError, ResourceNotFoundError


class MaintenancePlotError(Exception):
    pass


class MaintenancePlotNotFoundError(ResourceNotFoundError):
    def __init__(self):
        super().__init__("Specified Maintenance Plot doesn't exist.")


class MaintenancePlotScenarioSettingsTypeDoesntExists(ResourceNotFoundError):
    def __init__(self):
        super().__init__("Specified scenario type does not exists.")


class MaintenancePlotScenarioSettingsNotFoundError(ResourceNotFoundError):
    def __init__(self):
        super().__init__("Specified Maintenance Plot does not have settings for scenario of given type.")


class MaintenancePlotScenarioSettingsAlreadyExistError(ResourceAlreadyExistsError):
    def __init__(self):
        super().__init__("Settings already exist for given scenario type.")


class MaintenancePlotAlreadyExistError(ResourceAlreadyExistsError):
    def __init__(self):
        super().__init__("Maintenance plot with this ID already exists.")
