from walle.constants import LOGIN_RE


ABC_ROLE_SCOPE_SLUGS_SCHEMA = {
    "type": "array",
    "items": {
        "type": "string",
        "description": "ABC role scope slug",
    },
    "description": "ABC role scope slugs",
}

ABC_DUTY_SCHEDULE_SLUGS_SCHEMA = {
    "type": "array",
    "items": {
        "type": "string",
        "description": "ABC duty schedule slug",
    },
    "description": "ABC duty schedule slugs",
}

ABC_ROLES_CODES_SCHEMA = {
    "type": "array",
    "items": {
        "type": "string",
        "description": "ABC role code",
    },
    "description": "ABC roles codes",
}

ENABLE_REDEPLOY_AFTER_CHANGE_OF_MAC_ADDRESS = {
    "type": "boolean",
    "description": "Enable redeploy if hosts' mac addresses changed",
    "default": False,
}

ENABLE_MANUAL_APPROVAL_AFTER_HOSTS_POWER_OFF = {
    "type": "boolean",
    "description": "Enable manual approval after hosts power off",
    "default": False,
}

REQUEST_CMS_X_SECONDS_BEFORE_MAINTENANCE_START_TIME = {
    "anyOf": [{"type": "integer", "min_value": 0}, {"type": "null"}],
    "description": "Start requesting CMS to set maintenance on hosts X seconds before maintenance start time",
}

START_POWER_OFF_X_SECONDS_BEFORE_MAINTENANCE_START_TIME = {
    "anyOf": [{"type": "integer", "min_value": 0}, {"type": "null"}],
    "description": "Start power off hosts X seconds before maintenance start time",
}

GET_APPROVERS_TO_TICKET_IF_HOSTS_NOT_IN_MAINTENANCE_BY_START_TIME = {
    "type": "boolean",
    "description": "Get approvers to comment in startrek ticket in hosts "
    "not in maintenance by maintenance start time",
    "default": False,
}

IGNORE_CMS_ON_HOST_OPERATIONS = {
    "type": "boolean",
    "description": "Do not request CMS to release host on any host operations (set-to-maintenance, reboot, etc)",
    "default": False,
}

USE_YP_SLA = {
    "type": "boolean",
    "description": "Use special maintenance offset: two workdays in 4 day window before maintenance start time",
    "default": False,
}

GET_APPROVERS_TO_TICKET_IF_HOSTS_NOT_IN_MAINTENANCE_BY_X_SECONDS = {
    "anyOf": [{"type": "integer", "min_value": 0}, {"type": "null"}],
    "description": "Get approvers to comment in startrek ticket in hosts not in maintenance by x seconds",
}

APPROVAL_SLA = {
    "anyOf": [{"type": "integer", "min_value": 0}, {"type": "null"}],
    "description": "SLA for approval of maintenance by the owners",
}

DONT_CREATE_APPROVEMENT_IF_TOTAL_COUNT_OF_TAKEN_HOSTS_FROM_PLOT_LESS_THAN = {
    "anyOf": [{"type": "integer", "min_value": 0}, {"type": "null"}],
    "description": "Don't create an approvement if the total count of taken hosts linked to the maintenance plot is less than given numbers",
}

DONT_ALLOW_START_SCENARIO_IF_TOTAL_NUMBER_OF_ACTIVE_HOSTS_MORE_THAN = {
    "anyOf": [{"type": "integer", "min_value": 5}, {"type": "null"}],
    "description": "Don't allow start scenario if total number of active hosts more than entered number",
}

STAFF_LOGINS_SCHEMA = {
    "type": "array",
    "items": {
        "type": "string",
        "description": "Staff login",
        "pattern": LOGIN_RE,
    },
    "description": "Staff logins",
}
