import dataclasses
import typing


@dataclasses.dataclass(eq=True, frozen=True)
class HostTaskOffsetTimes:
    start_power_off_x_seconds_before_maintenance_start_time: typing.Optional[int] = None
    request_cms_x_seconds_before_maintenance_start_time: typing.Optional[int] = None


@dataclasses.dataclass(eq=True, frozen=True)
class BaseScenarioMaintenancePlotSettings:
    request_cms_x_seconds_before_maintenance_start_time: typing.Optional[int] = None

    use_yp_sla: bool = False

    jsonschema: typing.ClassVar = {}

    @classmethod
    def from_dict(cls, values_dict: dict):
        raise NotImplementedError

    @classmethod
    def to_dict(cls):
        raise NotImplementedError

    @classmethod
    def get_offset_times_of_host_tasks(cls):
        raise NotImplementedError

    @classmethod
    def get_restrictions_disabled_by_settings(self) -> list[str]:
        return []
