import dataclasses
import typing

from walle.maintenance_plot.exceptions import MaintenancePlotScenarioSettingsTypeDoesntExists
from walle.maintenance_plot.scenarios_settings.base import BaseScenarioMaintenancePlotSettings, HostTaskOffsetTimes


@dataclasses.dataclass(eq=True, frozen=True)
class HostsTransferMaintenancePlotSettings(BaseScenarioMaintenancePlotSettings):
    # TODO: we need actual settings here

    jsonschema: typing.ClassVar = {
        "type": "object",
        "properties": {},
        "additionalProperties": False,
        "description": "'hosts-transfer' scenario settings",
        "required": [],
    }

    @classmethod
    def from_dict(cls, values_dict: dict):
        return HostsTransferMaintenancePlotSettings()

    def to_dict(self):
        return {}

    def get_offset_times_of_host_tasks(self) -> HostTaskOffsetTimes:
        raise MaintenancePlotScenarioSettingsTypeDoesntExists()
