import dataclasses
import typing

from walle.maintenance_plot.jsonschema import (
    REQUEST_CMS_X_SECONDS_BEFORE_MAINTENANCE_START_TIME,
)
from walle.maintenance_plot.scenarios_settings.base import BaseScenarioMaintenancePlotSettings, HostTaskOffsetTimes


@dataclasses.dataclass(eq=True, frozen=True)
class NocSoftMaintenancePlotSettings(BaseScenarioMaintenancePlotSettings):
    request_cms_x_seconds_before_maintenance_start_time: typing.Optional[int] = None

    jsonschema: typing.ClassVar = {
        "type": "object",
        "properties": {
            "request_cms_x_seconds_before_maintenance_start_time": REQUEST_CMS_X_SECONDS_BEFORE_MAINTENANCE_START_TIME,
        },
        "additionalProperties": False,
        "description": "'noc-soft' scenario settings",
        "required": [],
    }

    @classmethod
    def from_dict(cls, values_dict: dict):
        return NocSoftMaintenancePlotSettings(
            request_cms_x_seconds_before_maintenance_start_time=values_dict.get(
                "request_cms_x_seconds_before_maintenance_start_time" or None
            ),
        )

    def to_dict(self):
        return {
            "request_cms_x_seconds_before_maintenance_start_time": self.request_cms_x_seconds_before_maintenance_start_time,
        }

    def get_offset_times_of_host_tasks(self) -> HostTaskOffsetTimes:
        return HostTaskOffsetTimes(
            request_cms_x_seconds_before_maintenance_start_time=self.request_cms_x_seconds_before_maintenance_start_time
        )
