from walle.authorization import blackbox
from walle.authorization import get_issuer_login
from walle.idm.role_tree import SpecificScenarioNode
from walle.scenario.constants import ScriptName
from walle.util.misc import values_filtered


def list_idm_role_members(scenario_type):
    return SpecificScenarioNode(scenario_type).list_role_members()


def authorize_scenario(scenario_type, issuer, owners=None):
    scenario_users = list_idm_role_members(scenario_type)

    if owners:
        scenario_users = list(scenario_users) + list(owners)

    blackbox.authorize(
        issuer, "You are not allowed to use this scenario.", owners=scenario_users, authorize_admins=True
    )


def authorize_operation_on_scenario(scenario, issuer):
    owners = {get_issuer_login(scenario.issuer)}
    if scenario.scenario_type in ScriptName.ALL_THIRD_PARTY_INIT_SCENARIOS:
        if scenario.labels:
            owners.update(values_filtered(scenario.labels, {"responsible", "ticket_created_by"}))
        if scenario.script_args:
            owners.update(values_filtered(scenario.script_args, {"responsible", "ticket_created_by"}))

    authorize_scenario(scenario.scenario_type, issuer, owners)
