import typing as tp

from walle.hosts import Host
from walle.scenario.definitions.base import get_data_storage
from walle.scenario.errors import ScenarioDoesNotHaveDefinition
from walle.scenario.scenario import Scenario


def get_scenario_info_for_cms(host: Host) -> dict[str, tp.Any]:
    if host.scenario_id is not None:
        scenario = Scenario.objects.get(scenario_id=host.scenario_id)
        try:
            data_storage = get_data_storage(scenario)
            scenario_parameters = data_storage.read_scenario_parameters()
            specific_scenario_params = scenario_parameters.get_cms_params()

            return dict(
                scenario_id=scenario.scenario_id, scenario_type=scenario.scenario_type, **specific_scenario_params
            )
        except ScenarioDoesNotHaveDefinition:
            pass
    return {}
