import enum


class ScriptName:
    # shortlist of known script names

    HOSTS_ADD = "hosts-add"
    """Add or Remove hosts to RTC with support for any host movements."""

    HOSTS_TRANSFER = "hosts-transfer"
    """Add or Remove hosts to RTC with support for any host movements."""

    RESERVED_HOSTS_TRANSFER = "reserved-hosts-transfer"
    """Move reserved hosts to RTC projects."""

    BENCHMARK = "benchmark"

    NOC_SOFT = "noc-soft"
    """NOC soft maintenance"""

    ITDC_MAINTENANCE = "itdc-maintenance"
    """ITDC maintenance"""

    YT_MAINTENANCE = "yt-maintenance"
    """https://st.yandex-team.ru/WALLESUPPORT-1778"""

    # NOTE(rocco66): https://st.yandex-team.ru/WALLE-3866
    # e.g. switch replacement, switch repairing
    NOC_HARD = "noc-hard"

    WAIT = "wait"
    """Just wait."""
    NOOP = "noop"
    """Do nothing."""

    SET_MAINTENANCE = "switch-to-maintenance"
    """Set maintenance for hosts"""

    SET_MAINTENANCE_WITH_GROUPS_APPROVES = "switch-to-maintenance-with-groups-approves"

    APPROVE = "approve"
    WAIT_TIME = "wait-time"

    ALL_THIRD_PARTY_INIT_SCENARIOS = {HOSTS_ADD, HOSTS_TRANSFER}
    ALL = [HOSTS_TRANSFER, NOC_SOFT, ITDC_MAINTENANCE, NOC_HARD, RESERVED_HOSTS_TRANSFER]

    ALL_EXISTING = [
        HOSTS_ADD,
        HOSTS_TRANSFER,
        NOC_SOFT,
        WAIT,
        NOOP,
        SET_MAINTENANCE_WITH_GROUPS_APPROVES,
        SET_MAINTENANCE,
        APPROVE,
        WAIT_TIME,
        ITDC_MAINTENANCE,
        NOC_HARD,
        BENCHMARK,
        RESERVED_HOSTS_TRANSFER,
        YT_MAINTENANCE,
    ]
    WITH_PROJECT_REQUEST_SEVERITY = [NOC_HARD, ITDC_MAINTENANCE, NOC_SOFT]


class SchedulerName:

    DATACENTER = "datacenter"
    """Process hosts by datacenter"""
    ALL = "all"
    """Process all hosts at once"""
    ONLY_PREVIOUSLY_ACQUIRED = "only_previously_acquired"
    """Process all hosts that were previously processed by another HSS"""
    MAINTENANCE_APPROVERS = "maintenance_approvers"

    CHOICES = [ALL, DATACENTER, MAINTENANCE_APPROVERS]


class ScenarioModifyAction:

    SKIP_WAIT_STAGE_FOR_HOSTS_TRANSFER = "skip_wait_stage_for_hosts_transfer"

    ALL = [SKIP_WAIT_STAGE_FOR_HOSTS_TRANSFER]


class StageName:

    SMS = "ScenarioMasterStage"
    SRS = "ScenarioRootStage"
    ITDCWS = "ITDCWorkflowStage"
    MaintenanceApproversWorkflowStage = "MaintenanceApproversWorkflowStage"
    DumpApproversListStage = "DumpApproversListStage"
    CallOnResponsibleForLoadReturn = "CallOnResponsibleForLoadReturn"

    HMS = "HostMasterStage"
    HRS = "HostRootStage"

    HSS = "HostSchedulerStage"
    THSS = "TimedHostSchedulerStage"
    HostGroupSchedulerStage = "HostGroupSchedulerStage"

    NoopStage = "NoopStage"

    SetAssignedStage = "SetAssignedStage"
    WaitForLabelOrTimeStage = "WaitForLabelOrTimeStage"
    PrepareForWorkStage = "PrepareForWorkStage"
    SetLabelStage = "SetLabelStage"
    SetStartedWorkStatusStage = "SetStartedWorkStatusStage"
    SetApprovementWorkStatusStage = "SetApprovementWorkStatusStage"
    SetAcquiringPermissionStatusStage = "SetAcquiringPermissionStatusStage"
    SetReadyWorkStatusStage = "SetReadyWorkStatusStage"
    SetFinishingWorkStatusStage = "SetFinishingWorkStatusStage"
    SetFinishedWorkStatusStage = "SetFinishedWorkStatusStage"
    SetLabelIfAllScheduledStage = "SetLabelIfAllScheduledStage"
    CancelTaskStage = "CancelTaskStage"

    AcquirePermission = "AcquirePermission"
    ApproveStage = "ApproveStage"
    HostGroupApproveStage = "HostGroupApproveStage"
    NocHardHostGroupApproveStage = "NocHardHostGroupApproveStage"
    ManualConfirmationHostGroupApproveStage = "ManualConfirmationHostGroupApproveStage"

    AddStartrekMessageStage = "AddStartrekMessageStage"
    AddStartrekHostGroupMessageStage = "AddStartrekHostGroupMessageStage"
    AddStartrekTagStage = "AddStartrekTagStage"
    CreateStartrekTicketStage = "CreateStartrekTicketStage"
    ExecuteTicketTransitionStage = "ExecuteTicketTransitionStage"
    SwitchToMaintenanceHostStage = "SwitchToMaintenanceHostStage"
    CheckAndReportAboutDeadlinesStage = "CheckAndReportAboutDeadlinesStage"
    CheckAndReportAboutHostRestrictionsStage = "CheckAndReportAboutHostRestrictionsStage"
    PowerOffHostStage = "PowerOffHostStage"
    LiberateFromQloudHostStage = "LiberateFromQloudHostStage"
    SwitchProjectHostStage = "SwitchProjectHostStage"
    PrepareHostStage = "PrepareHostStage"
    AddHostsStage = "AddHostsStage"
    RemoveHostsStage = "RemoveHostsStage"
    SwitchScenarioToHostUUID = "SwitchScenarioToHostUUID"
    ProfileHostStage = "ProfileHostStage"
    SwitchVlansHostStage = "SwitchVlansHostStage"
    RedeployHostStage = "RedeployHostStage"
    OptionalRedeployHostStage = "OptionalRedeployHostStage"
    RebootHostStage = "RebootHostStage"
    CheckDnsHostStage = "CheckDnsHostStage"
    EnsureDnsAccessStage = "EnsureDnsAccessStage"
    DetectStorageStage = "DetectStorageStage"
    ReleaseHostStage = "ReleaseHostStage"
    SetABCServiceIdStage = "SetABCServiceIdStage"
    HostGroupWaitBeforeRequestingCmsStage = "HostGroupWaitBeforeRequestingCmsStage"
    HostWaitBeforeRequestingCmsStage = "HostWaitBeforeRequestingCmsStage"
    CheckAndSkipIfSecondOkEnabledStage = "CheckAndSkipIfSecondOkEnabledStage"

    # TODO(rocco66): rename to noc soft in DB
    NocMaintenanceStage = "NocMaintenanceStage"
    FinishNocMaintenanceStage = "FinishNocMaintenanceStage"

    WaitStateStatusHostStage = "WaitStateStatusHostStage"
    CollectHealthChecksStage = "CollectHealthChecksStage"

    WaitEineProfileHostStage = "WaitEineProfileHostStage"

    LambdaStage = "LambdaStage"
    ConditionalHostStage = "ConditionalHostStage"

    TimeoutStage = "TimeoutStage"
    """deprecated"""
    SwitchProjectStage = "SwitchProjectStage"
    PrepareStage = "PrepareStage"
    WaitAssignedReadyHostStage = "WaitAssignedReadyHostStage"
    WaitTimeStage = "WaitTimeStage"
    WaitHourStage = "WaitHourStage"

    NoopHostStage = "NoopHostStage"
    NoopHostStageSuccess = "NoopHostStageSuccess"


class ScriptArgs:
    TARGET_PROJECT = "target_project_id"
    SCHEDULE_TYPE = "schedule_type"
    TARGET_SEGMENT = "target_hardware_segment"
    DELETE = "delete"
    IDLE_TIME = "idle_time"
    LABEL_NAME = "label_name"
    LABEL_VALUE = "label_value"
    LABEL_VALUE_ALTERNATIVE = "label_value_alternative"
    LABEL_VALUES = "label_values"
    INTERMEDIATE_PROJECT = "intermediate_project"


WORK_STATUS_API_PARAM = "work_status"


class ScenarioWorkStatus(str, enum.Enum):
    CREATED = "created"
    ACQUIRING_PERMISSION = "acquiring permission"
    STARTED = "started"
    APPROVEMENT = "approvement"
    READY = "ready"
    FINISHING = "finishing"
    FINISHED = "finished"
    CANCELING = "canceling"
    CANCELED = "canceled"
    REJECTED = "rejected"


ALL_TERMINATION_WORK_STATUSES = [
    ScenarioWorkStatus.REJECTED,
    ScenarioWorkStatus.CANCELING,
    ScenarioWorkStatus.CANCELED,
    ScenarioWorkStatus.FINISHING,
    ScenarioWorkStatus.FINISHED,
]
ALL_CANCELATION_WORK_STATUSES = [
    ScenarioWorkStatus.REJECTED,
    ScenarioWorkStatus.CANCELING,
    ScenarioWorkStatus.CANCELED,
]


class HostScenarioStatus:
    QUEUE = "queue"
    """Host is queued for processing, not acquired yet."""

    ACQUIRED = "acquired"
    """Host is acquired and scheduled for processing."""

    PROCESSING = "processing"
    """Host is being processed."""

    DONE = "done"
    """Host is done processing."""

    CANCELED = "canceled"
    """Host processing has been canceled."""

    ALL = [QUEUE, ACQUIRED, PROCESSING, DONE, CANCELED]
    """All existing host statuses."""

    ALL_SCHEDULED = {ACQUIRED, PROCESSING}
    """All statuses for acquired but not finished hosts."""


class ScenarioFsmStatus(str, enum.Enum):
    CREATED = "created"
    STARTED = "started"
    FINISHED = "finished"
    CANCELING = "canceling"
    CANCELED = "canceled"
    PAUSED = "paused"


ALL_CANCELABLE_SCENARIO_STATUSES = [
    ScenarioFsmStatus.CREATED,
    ScenarioFsmStatus.STARTED,
    ScenarioFsmStatus.PAUSED,
]
ALL_CAN_PAUSE_SCENARIO_STATUSES = [
    ScenarioFsmStatus.STARTED,
]
ALL_CAN_START_SCENARIO_STATUSES = [
    ScenarioFsmStatus.CREATED,
    ScenarioFsmStatus.PAUSED,
]
ALL_FSM_RUNNABLE_SCENARIO_STATUSES = [
    ScenarioFsmStatus.STARTED,
    ScenarioFsmStatus.CANCELING,
]


class TicketStatus:  # Needs to be removed in favor of walle.clients.startrek.TicketStatus
    OPEN = 'open'
    CLOSED = 'closed'


class TicketTransition:
    CLOSE = "close"
    READY_FOR_DEV = "readyForDev"
    IN_PROGRESS = "inProgress"


TICKET_RESOLUTION = "fixed"


ADMIN_PARAM_NAMES_OF_HOST_TRANSFER = ["idle_time", "workdays_only"]


class TemplatePath(str, enum.Enum):
    """
    Templates are rendered with only scenario_id context parameter.
    """

    OK_APPROVE_MESSAGE = "scenario/ok_approve_message_hosts_init.txt"
    STARTREK_APPROVE_MESSAGE = "scenario/startrek_approve_body.txt"
    STARTREK_EMERGENCY = "scenario/startrek_emergency_message.txt"
    STARTREK_START_SCENARIO = "scenario/startrek_start_scenario_hosts_init.txt"
    STARTREK_END_SCENARIO = "scenario/startrek_end_scenario_hosts_init.txt"
    STARTREK_APPROVE_CANCELED = "scenario/startrek_approve_canceled.txt"
    STARTREK_APPROVE_HOSTS_DIFF = "scenario/startrek_approve_hosts_diff.txt"
    STARTREK_DNS_REQUEST = "scenario/startrek_dns_request.txt"
    STARTREK_STORAGE_INFO = "scenario/startrek_storage_info.txt"
    STARTREK_SCENARIO_CANCELLED = "scenario/startrek_scenario_cancelled.txt"
    STARTREK_SCENARIO_GET_RESPONSIBLES_TO_TICKET = "scenario/startrek_get_responsibles_to_ticket.txt"
    STARTREK_CHECK_AND_REPORT_ABOUT_RESTRICTIONS = "scenario/check_and_report_about_host_restrictions_stage.txt"

    STARTREK_START_ITDC_MAINTENANCE_SCENARIO = "scenario/itdc_maintenance/startrek_start_scenario.txt"
    OK_ITDC_MAINTENANCE_HOST_GROUP_APPROVE_REQUEST = "scenario/itdc_maintenance/ok_host_group_approve_request.txt"
    STARTREK_ITDC_MAINTENANCE_HOST_GROUP_APPROVEMENT_TEXT = "scenario/itdc_maintenance/startrek_approvement_text.txt"
    STARTREK_ITDC_MAINTENANCE_HOST_GROUP_APPROVE_ESCALATION = (
        "scenario/itdc_maintenance/startrek_host_group_approve_escalation.txt"
    )
    STARTREK_ITDC_MAINTENANCE_HOST_GROUP_RECEIVED_APPROVE = (
        "scenario/itdc_maintenance/startrek_host_group_received_approve.txt"
    )
    STARTREK_ITDC_MAINTENANCE_HOST_GROUP_APPROVE_REJECTED = (
        "scenario/itdc_maintenance/startrek_host_group_approve_declined.txt"
    )
    STARTREK_ITDC_MAINTENANCE_READY_FOR_WORK = "scenario/itdc_maintenance/startrek_host_ready_for_work.txt"
    STARTREK_ITDC_MAINTENANCE_HOST_REVIVAL_STARTED = "scenario/itdc_maintenance/startrek_host_revival.txt"
    STARTREK_END_ITDC_MAINTENANCE_SCENARIO = "scenario/itdc_maintenance/startrek_end_scenario.txt"

    STARTREK_START_NOC_HARD_SCENARIO = "scenario/noc_hard/startrek_start_scenario.txt"
    OK_NOC_HARD_HOST_GROUP_APPROVE_REQUEST = "scenario/noc_hard/ok_host_group_approve_request.txt"
    STARTREK_NOC_HARD_HOST_GROUP_APPROVEMENT_TEXT = "scenario/noc_hard/startrek_approvement_text.txt"
    STARTREK_NOC_HARD_HOST_GROUP_RECEIVED_APPROVE = "scenario/noc_hard/startrek_host_group_received_approve.txt"
    STARTREK_NOC_HARD_HOST_GROUP_APPROVE_REJECTED = "scenario/noc_hard/startrek_host_group_approve_declined.txt"
    STARTREK_NOC_HARD_HOST_READY_FOR_WORK = "scenario/noc_hard/startrek_host_ready_for_work.txt"
    STARTREK_NOC_HARD_HOST_REVIVAL_STARTED = "scenario/noc_hard/startrek_host_revival.txt"
    STARTREK_END_NOC_HARD_SCENARIO = "scenario/noc_hard/startrek_end_scenario.txt"

    COMMON_HOST_GROUP_APPROVE_REQUEST = "scenario/common/ok_host_group_approve_request.txt"
    COMMON_HOST_GROUP_APPROVEMENT_TEXT = "scenario/common/startrek_approvement_text.txt"
    COMMON_HOST_GROUP_RECEIVED_APPROVE = "scenario/common/startrek_host_group_received_approve.txt"
    COMMON_HOST_GROUP_APPROVE_REJECTED = "scenario/common/startrek_host_group_approve_declined.txt"


class CustomTemplatePath(str, enum.Enum):
    """
    Other templates.
    """

    STARTREK_DUMP_APPROVERS_LIST = "scenario/dump_approvers_list.txt"


WORKMATE_STATUS_LABEL_NAME = "WORK_COMPLETED"
WORKMATE_STATUS_TARGET_LABEL_VALUE = "true"

WORK_STATUS_LABEL_NAME = "WORK_STATUS"
DATACENTER_LABEL_NAME = "DATACENTER"
SWITCH_LABEL_NAME = "SWITCH"
RESERVED_LABELS = [WORK_STATUS_LABEL_NAME, DATACENTER_LABEL_NAME, SWITCH_LABEL_NAME]


class SharedDataKey:
    HOST_NETWORK_INFO = "host network info"


class ConditionFunction:
    ITDC_MAINTENANCE_REDEPLOY_NEEDED = "itdc_maintenance_redeploy_needed"
    ITDC_MAINTENANCE_REBOOT_NEEDED = "itdc_maintenance_reboot_needed"


class FixedMaintenanceApproversLogins:
    DEFAULT_MAINTENANCE_APPROVERS_LOGINS = ["evgenyemets", "zeebdo", "warwish"]
    YABS_MAINTENANCE_APPROVERS_LOGINS = ["evgenyemets", "zeebdo", "warwish"]  # ["bahbka"]
    YT_MAINTENANCE_APPROVERS_LOGINS = ["evgenyemets", "zeebdo", "warwish", "verytable", "psushin", "k-malov"]


class TicketTags:
    CREATED = "scenario_created"
    APPROVED = "scenario_approved"
    PROCESSING = "scenario_processing"


DEFAULT_STAGE_DESCRIPTION = "No description yet"

SOFT_NOC_WORK_TIMEOUT = 60 * 60
SOFT_NOC_LOAD_RETURN_TIMEOUT = 65 * 60

SOFT_NOC_LOAD_RETURN_TIMEOUT_JUGGLER_SERVICE_NAME = "wall-e.noc-load-return-timeout-report"
NOC_SOFT_WORK_TIMEOUT_JUGGLER_SERVICE_NAME = "wall-e.noc-work-timeout-report"


class HostGroupsBuildersSpecificProjectTags:
    YT_MASTERS_PROJECT_TAG = "rtc.reboot_segment-yt_masters"
    YT_PROJECT_TAG = "yt"
    YP_PROJECT_TAG = "yp"
    YABS_PROJECT_TAG = "yabs"


class YtMastersProjectTagMaintenancePlotData:
    ID = "yt masters"
    META_INFO = {
        "abc_service_slug": "yt",
        "name": (
            f"Hard-coded maintenance plot for projects with "
            f"'{HostGroupsBuildersSpecificProjectTags.YT_MASTERS_PROJECT_TAG}' tag"
        ),
    }
    COMMON_SETTINGS = {
        "maintenance_approvers": {
            "logins": FixedMaintenanceApproversLogins.YT_MAINTENANCE_APPROVERS_LOGINS,
            "abc_roles_codes": [],
            "abc_role_scope_slugs": [],
        },
        "common_scenario_settings": {
            "total_number_of_active_hosts": None,
            "dont_allow_start_scenario_if_total_number_of_active_hosts_more_than": None,
        },
    }
    SCENARIOS_SETTINGS = [
        {
            "scenario_type": "itdc-maintenance",
            "settings": {
                "request_cms_x_seconds_before_maintenance_start_time": 2 * 60 * 60,
                "enable_redeploy_after_change_of_mac_address": False,
                "start_power_off_x_seconds_before_maintenance_start_time": 2 * 60 * 60,
                "get_approvers_to_ticket_if_hosts_not_in_maintenance_by_start_time": True,
                "get_approvers_to_ticket_if_hosts_not_in_maintenance_by_x_seconds": 1 * 60 * 60,
                "ignore_cms_on_host_operations": False,
                "approval_sla": 2 * 24,
            },
        },
        {
            "scenario_type": "noc-hard",
            "settings": {
                "request_cms_x_seconds_before_maintenance_start_time": 2 * 60 * 60,
                "enable_redeploy_after_change_of_mac_address": False,
                "get_approvers_to_ticket_if_hosts_not_in_maintenance_by_start_time": True,
                "get_approvers_to_ticket_if_hosts_not_in_maintenance_by_x_seconds": 1 * 60 * 60,
                "ignore_cms_on_host_operations": False,
                "approval_sla": 2 * 24,
            },
        },
    ]


class YtProjectTagMaintenancePlotData:
    ID = "yt"
    META_INFO = {
        "abc_service_slug": "yt",
        "name": (
            f"Hard-coded maintenance plot for projects with "
            f"'{HostGroupsBuildersSpecificProjectTags.YT_PROJECT_TAG}' tag"
        ),
    }
    COMMON_SETTINGS = {
        "maintenance_approvers": {
            "logins": FixedMaintenanceApproversLogins.YT_MAINTENANCE_APPROVERS_LOGINS,
            "abc_roles_codes": [],
            "abc_role_scope_slugs": [],
        },
        "common_scenario_settings": {
            "total_number_of_active_hosts": None,
            "dont_allow_start_scenario_if_total_number_of_active_hosts_more_than": None,
        },
    }
    SCENARIOS_SETTINGS = [
        {
            "scenario_type": "itdc-maintenance",
            "settings": {
                "request_cms_x_seconds_before_maintenance_start_time": 24 * 60 * 60,
                "enable_redeploy_after_change_of_mac_address": True,
                "start_power_off_x_seconds_before_maintenance_start_time": 24 * 60 * 60,
                "get_approvers_to_ticket_if_hosts_not_in_maintenance_by_start_time": True,
                "get_approvers_to_ticket_if_hosts_not_in_maintenance_by_x_seconds": 90 * 60,
                "ignore_cms_on_host_operations": False,
                "approval_sla": 2 * 24,
            },
        },
        {
            "scenario_type": "noc-hard",
            "settings": {
                "request_cms_x_seconds_before_maintenance_start_time": 24 * 60 * 60,
                "enable_redeploy_after_change_of_mac_address": True,
                "get_approvers_to_ticket_if_hosts_not_in_maintenance_by_start_time": True,
                "get_approvers_to_ticket_if_hosts_not_in_maintenance_by_x_seconds": 90 * 60,
                "ignore_cms_on_host_operations": False,
                "approval_sla": 2 * 24,
            },
        },
    ]


class YpProjectTagMaintenancePlotData:
    ID = "yp"
    META_INFO = {
        "abc_service_slug": "yp",
        "name": (
            f"Hard-coded maintenance plot for projects with "
            f"'{HostGroupsBuildersSpecificProjectTags.YP_PROJECT_TAG}' tag"
        ),
    }
    COMMON_SETTINGS = {
        "maintenance_approvers": {
            "logins": FixedMaintenanceApproversLogins.DEFAULT_MAINTENANCE_APPROVERS_LOGINS,
            "abc_roles_codes": [],
            "abc_role_scope_slugs": [],
        },
        "common_scenario_settings": {
            "total_number_of_active_hosts": None,
            "dont_allow_start_scenario_if_total_number_of_active_hosts_more_than": None,
        },
    }
    SCENARIOS_SETTINGS = [
        {
            "scenario_type": "itdc-maintenance",
            "settings": {
                "request_cms_x_seconds_before_maintenance_start_time": 3 * 24 * 60 * 60,
                "enable_redeploy_after_change_of_mac_address": True,
                "start_power_off_x_seconds_before_maintenance_start_time": 3 * 3600,
                "get_approvers_to_ticket_if_hosts_not_in_maintenance_by_start_time": True,
                "get_approvers_to_ticket_if_hosts_not_in_maintenance_by_x_seconds": 3 * 60 * 60,
                "ignore_cms_on_host_operations": False,
                "use_yp_sla": True,
                "approval_sla": 3 * 24,
            },
        },
        {
            "scenario_type": "noc-hard",
            "settings": {
                "request_cms_x_seconds_before_maintenance_start_time": 3 * 24 * 60 * 60,
                "enable_redeploy_after_change_of_mac_address": True,
                "get_approvers_to_ticket_if_hosts_not_in_maintenance_by_start_time": True,
                "get_approvers_to_ticket_if_hosts_not_in_maintenance_by_x_seconds": 3 * 60 * 60,
                "ignore_cms_on_host_operations": False,
                "use_yp_sla": True,
                "approval_sla": 3 * 24,
            },
        },
    ]


class YabsProjectTagMaintenancePlotData:
    ID = "yabs"
    META_INFO = {
        "abc_service_slug": "yabs",
        "name": (
            f"Hard-coded maintenance plot for projects with "
            f"'{HostGroupsBuildersSpecificProjectTags.YABS_PROJECT_TAG}' tag"
        ),
    }
    COMMON_SETTINGS = {
        "maintenance_approvers": {
            "logins": FixedMaintenanceApproversLogins.DEFAULT_MAINTENANCE_APPROVERS_LOGINS,
            "abc_roles_codes": [],
            "abc_role_scope_slugs": [],
        },
        "common_scenario_settings": {
            "total_number_of_active_hosts": None,
            "dont_allow_start_scenario_if_total_number_of_active_hosts_more_than": None,
        },
    }
    SCENARIOS_SETTINGS = [
        {
            "scenario_type": "itdc-maintenance",
            "settings": {
                "request_cms_x_seconds_before_maintenance_start_time": 24 * 60 * 60,
                "enable_redeploy_after_change_of_mac_address": True,
                "start_power_off_x_seconds_before_maintenance_start_time": 24 * 60 * 60,
                "get_approvers_to_ticket_if_hosts_not_in_maintenance_by_start_time": True,
                "get_approvers_to_ticket_if_hosts_not_in_maintenance_by_x_seconds": 3 * 60 * 60,
                "ignore_cms_on_host_operations": False,
                "approval_sla": 2 * 24,
            },
        },
        {
            "scenario_type": "noc-hard",
            "settings": {
                "request_cms_x_seconds_before_maintenance_start_time": 24 * 60 * 60,
                "enable_redeploy_after_change_of_mac_address": True,
                "get_approvers_to_ticket_if_hosts_not_in_maintenance_by_start_time": True,
                "get_approvers_to_ticket_if_hosts_not_in_maintenance_by_x_seconds": 3 * 60 * 60,
                "ignore_cms_on_host_operations": False,
                "approval_sla": 2 * 24,
            },
        },
    ]


SPECIFIC_PROJECT_TAG_TO_MAINTENANCE_PLOT_DATA_MAP = {
    HostGroupsBuildersSpecificProjectTags.YT_MASTERS_PROJECT_TAG: YtMastersProjectTagMaintenancePlotData,
    HostGroupsBuildersSpecificProjectTags.YT_PROJECT_TAG: YtProjectTagMaintenancePlotData,
    HostGroupsBuildersSpecificProjectTags.YP_PROJECT_TAG: YpProjectTagMaintenancePlotData,
    HostGroupsBuildersSpecificProjectTags.YABS_PROJECT_TAG: YabsProjectTagMaintenancePlotData,
}


class MaintenanceGroupProjectTags:
    YT_MASTERS_PROJECT_TAG = "rtc.reboot_segment-yt_masters"
    YT_PROJECT_TAG = "yt"
    YP_PROJECT_TAG = "yp"
    YABS_PROJECT_TAG = "yabs"

    # WALLE-4081 Order of known tags matters.
    ALL = [
        YT_MASTERS_PROJECT_TAG,
        YT_PROJECT_TAG,
        YP_PROJECT_TAG,
        YABS_PROJECT_TAG,
    ]


class StageGeneratorName:
    ITDC_MAINTENANCE_STAGE_GENERATOR = 'ITDCMaintenanceStageGenerator'
    NOC_HARD_STAGE_GENERATOR = 'NocHardStageGenerator'
