"""Controls scenario runner."""

import logging

from walle.util import mongo

log = logging.getLogger(__name__)


SHARDS_NUM_PATH = "task_processing.shards_num"  # TODO(rocco66): remove after WALLE-3967
MAX_CONCURRENCY_PATH = "task_processing.max_concurrency"


_SCENARIO = None
"""Scenario instance."""


def start(settings):
    """Starts Scenario FSM.

    Function is not thread-safe.
    """

    global _SCENARIO
    if _SCENARIO is not None:
        return

    from walle.scenario.scenario_fsm import ScenarioFsm

    partitioner = mongo.MongoPartitionerService("scenarios")
    runner = ScenarioFsm(settings, SHARDS_NUM_PATH, MAX_CONCURRENCY_PATH, partitioner)
    runner.start()

    _SCENARIO = runner


def stop():
    """Stops Scenario FSM.

    Function is not thread-safe.
    """

    global _SCENARIO

    runner, _SCENARIO = _SCENARIO, None
    if runner:
        runner.stop()
